<?php
/**
 * Filter Layout.
 *
 * This template can be overridden by copying it to yourtheme/testimonial-pro/templates/filter.php
 *
 * @package    Testimonial_Pro
 * @subpackage Testimonial_Pro/Frontend
 */

use ShapedPlugin\TestimonialPro\Frontend\Helper;
?>
<div id="sp-testimonial-pro-wrapper-<?php echo esc_attr( $post_id ); ?>" class="sp-testimonial-pro-wrapper <?php echo esc_attr( $image_zoom ); ?>" data-testimonial-id= "<?php echo esc_attr( $post_id ); ?>" data-layout= "<?php echo esc_attr( $layout ); ?>">
<?php
require self::sptp_locate_template( 'top-section.php' );
?>
<div id="sp-testimonial-pro-<?php echo esc_attr( $post_id ); ?>" <?php echo wp_kses_post( $the_rtl ) . ' ' . wp_kses_post( $data_attr ); ?> class="sp-testimonial-pro-section <?php echo esc_attr( $pagination_type ); ?> sp-testimonial-pro-read-more tpro-readmore-<?php echo esc_attr( $testimonial_read_more_link_action ) . '-' . esc_attr( $testimonial_read_more_class ) . ' sp_testimonial_pro_filter tpro-style-' . esc_attr( $theme_style ); ?>" data-filter_mode='<?php echo esc_attr( $tpro_filter_config ); ?>'>
	<?php
		$filter_button_array = Helper::isotope_button_meta( $testimonial_query_and_ids['all_testimonial_ids'], $shortcode_data, $post_id );
	if ( ! is_tax() ) {
		$count = count( $filter_button_array['category'] );
		if ( $count > 0 ) {
			echo '<div class="sp-tpro-filter"><ul class="sp-tpro-items-filter">';
			if ( $all_tab_show && ! empty( $all_tab_text ) ) {
				echo '<li><a href="#" class="active"  data-filter="*">' . esc_html( $all_tab_text ) . '</a></li>';
			}
			foreach ( $filter_button_array['category'] as $testimonial_group ) {
				if ( isset( $testimonial_group['name'] ) ) {
					echo '<li><a href="#" data-filter=".testimonial_cat-' . esc_attr( $testimonial_group['slug'] ) . '">' . esc_html( $testimonial_group['name'] ) . '</a></li>';
				}
			}
			echo '</ul></div>';
		}
	}
	?>
<div class="sp-tpro-isotope-items">
<?php
echo $testimonial_items['output'];
?>
</div>
<?php require self::sptp_locate_template( 'pagination.php' ); ?>
</div>
</div>
