<?php

namespace WPFormsAWeber\Api;

/**
 * AWeberResponse class.
 *
 * Base class for objects that represent a response from the AWeberAPI.
 * Responses will exist as one of the two AWeberResponse subclasses:
 *  - AWeberEntry - a single instance of an AWeber resource
 *  - AWeberCollection - a collection of AWeber resources
 *
 * @since 2.0.0
 */
class AWeberResponse extends Api {

	/**
	 * The adapter.
	 *
	 * @since 2.0.0
	 *
	 * @var null|OAuth2Adapter
	 */
	public $adapter;

	/**
	 * The URL.
	 *
	 * @since 2.0.0
	 *
	 * @var string
	 */
	public $url = '';

	/**
	 * The data.
	 *
	 * @since 2.0.0
	 *
	 * @var array
	 */
	public $data = [];

	/**
	 * Dynamic data.
	 *
	 * @since 2.0.0
	 *
	 * @var array
	 */
	public $dynamic_data = [];

	/**
	 * Constructor.
	 *
	 * @since 2.0.0
	 *
	 * @param mixed $response Data returned by the API servers.
	 * @param mixed $url      URL we hit to get the data.
	 * @param mixed $adapter  OAuth adapter used for future interactions.
	 *
	 * @access public
	 * @return void
	 */
	public function __construct( $response, $url, $adapter ) {

		$this->adapter = $adapter;
		$this->url     = $url;
		$this->data    = $response;
	}

	/**
	 * Get a property.
	 *
	 * Defers first to the data in $this->data.
	 *
	 * @since 2.0.0
	 *
	 * @param string $value Property name.
	 *
	 * @access public
	 * @return mixed
	 */
	public function __get( $value ) {

		if ( in_array( $value, $this->private_data, true ) ) {
			return null;
		}

		if ( array_key_exists( $value, $this->data ) ) {
			return $this->data[ $value ];
		}

		if ( $value === 'type' ) {
			return $this->get_type();
		}

		return null;
	}

	/**
	 * Set a property.
	 *
	 * Manual re-implementation of __set, allows sub classes to access the default behavior by using the parent:: format.
	 *
	 * @since 2.0.0
	 *
	 * @param mixed $key   Key of the attr being set.
	 * @param mixed $value Value being set to the attr.
	 *
	 * @access public
	 */
	public function __set( $key, $value ) {

		$this->{$key} = $value;
	}

}
