<?php

namespace WPFormsAWeber\Api;

/**
 * AuthQuery class.
 *
 * Responsible for constructing the authorization URL
 * from the client_id and the code_challenge.
 *
 * @since 2.0.0
 */
class AuthQuery {

	/**
	 * The URL to direct the user to for the authorization code.
	 *
	 * @since 2.0.0
	 *
	 * @var string
	 */
	const URL = 'https://auth.aweber.com/oauth2/authorize';

	/**
	 * Build the authorization query.
	 *
	 * @since 2.0.0
	 *
	 * @param string $client_id      The client ID.
	 * @param string $code_challenge The code challenge.
	 *
	 * @return string
	 */
	public static function create(
		$client_id = '',
		$code_challenge = ''
	) {

		$scopes = [
			'account.read',
			'email.read',
			'email.write',
			'list.read',
			'list.write',
			'subscriber.read-extended',
			'subscriber.read',
			'subscriber.write',
		];

		$auth_query_params = [
			'response_type'         => 'code',
			'client_id'             => $client_id,
			'redirect_uri'          => 'urn:ietf:wg:oauth:2.0:oob',
			'scope'                 => implode( '+', $scopes ),
			'state'                 => uniqid( '', true ),
			'code_challenge'        => $code_challenge,
			'code_challenge_method' => CodeChallenge::CODE_CHALLENGE_METHOD,
		];

		return add_query_arg(
			$auth_query_params,
			self::URL
		);
	}
}
