<?php

namespace WPFormsAWeber\Api;

/**
 * Class Client creates new connections between addon and the AWeber API.
 *
 * @since 2.0.0
 */
class Client {

	/**
	 * Create a new connection.
	 *
	 * @since 2.0.0
	 *
	 * @param string      $access_token  The access token.
	 * @param string      $refresh_token The refresh token.
	 * @param int         $expires_on    The access token expiration timestamp.
	 * @param null|string $account_id    The account ID.
	 *
	 * @return Api
	 */
	public function new_connection(
		$access_token,
		$refresh_token,
		$expires_on,
		$account_id = null
	) {

		return new Api(
			$access_token,
			$refresh_token,
			$expires_on,
			$account_id
		);
	}
}
