<?php

namespace WPFormsAWeber\Api;

use Exception;

/**
 * CodeChallenge class.
 *
 * Responsible for constructing the code_challenge from the code_verifier.
 *
 * @since 2.0.0
 */
class CodeChallenge {
	/**
	 * This OAuth2 PKCE Code Challenge Method.
	 *
	 * @link https://datatracker.ietf.org/doc/html/rfc7636#section-4.2
	 *
	 * @since 2.0.0
	 *
	 * @var string
	 */
	const CODE_CHALLENGE_METHOD = 'S256';

	/**
	 * Create the code challenge.
	 *
	 * @since 2.0.0
	 *
	 * @param string $code_verifier The code verifier string.
	 *
	 * @return string
	 * @throws Exception On failure.
	 */
	public static function create( $code_verifier = '' ) {
		// Very important, "raw_output" must be set to true or the challenge
		// will not match the verifier.
		$challenge_bytes = hash(
			'sha256',
			$code_verifier,
			true
		);

		// phpcs:disable WordPress.PHP.DiscouragedPHPFunctions.obfuscation_base64_encode
		return rtrim(
			strtr(
				base64_encode(
					$challenge_bytes
				),
				'+/',
				'-_'
			),
			'='
		);
		// phpcs:enable WordPress.PHP.DiscouragedPHPFunctions.obfuscation_base64_encode
	}
}
