<?php

namespace WPFormsAWeber\Api;

use Exception;

/**
 * CodeVerifier class.
 *
 * Responsible for constructing the code_verifier
 * used for the code_challenge and token exchange.
 *
 * @since 2.0.0
 */
class CodeVerifier {

	/**
	 * Create a code verifier.
	 *
	 * Note: The same code_verifier used to create the code_challenge
	 * is also required for the token exchange!
	 *
	 * @since 2.0.0
	 *
	 * @return string
	 * @throws Exception On failure.
	 */
	public static function create() {

		// WordPress ships with paragonie/random_compat random_bytes() polyfill since at least WP Version 4.4.
		// phpcs:ignore PHPCompatibility.FunctionUse.NewFunctions.random_bytesFound
		$verifier_bytes = random_bytes( 64 );

		// phpcs:disable WordPress.PHP.DiscouragedPHPFunctions.obfuscation_base64_encode -- Legitimate use of base64_encode().
		return rtrim(
			strtr(
				base64_encode(
					$verifier_bytes
				),
				'+/',
				'-_'
			),
			'='
		);
		// phpcs:enable WordPress.PHP.DiscouragedPHPFunctions.obfuscation_base64_encode
	}
}
