<?php

namespace WPFormsAWeber\Api;

/**
 * Class OAuth2App.
 *
 * @since 2.0.0
 */
class OAuth2App {

	/**
	 * AWeber API Base URI.
	 *
	 * @since 2.0.0
	 *
	 * @var string
	 */
	const BASE_URI = 'https://api.aweber.com/1.0';

	/**
	 * Remove the base URI.
	 *
	 * CamelCase method name required by AWeberCollection.
	 *
	 * @see AWeberCollection::offsetGet() -- $this->adapter->app->remove_base_uri($entry['self_link'])
	 *
	 * @since 2.0.0
	 *
	 * @param string $url The URL without the base.
	 *
	 * @return string
	 */
	public function remove_base_uri( $url ) {

		return str_replace( $this->get_base_uri(), '', $url );
	}

	/**
	 * Get the base URI.
	 *
	 * CamelCase method name required by AWeberAPIBase, AWeberEntry.
	 *
	 * @since 2.0.0
	 *
	 * @see Api::clean_url() -- $this->adapter->app->get_base_uri()
	 * @see AWeberEntry::parse_named_operation() -- $this->adapter->app->get_base_uri()
	 *
	 * @return string
	 */
	public function get_base_uri() {

		return self::BASE_URI;
	}
}
