<?php

namespace WPFormsAWeber\Api;

/**
 * TokenQuery class.
 *
 * Responsible for constructing the token exchange URL.
 *
 * @since 2.0.0
 */
class TokenQuery {

	/**
	 * The URL to retrieve the token.
	 *
	 * @since 2.0.0
	 *
	 * @var string
	 */
	const URL = 'https://auth.aweber.com/oauth2/token';

	/**
	 * Create the token query.
	 *
	 * @since 2.0.0
	 *
	 * @param string $authorization_code The authorization code.
	 * @param string $client_id          The client ID.
	 * @param string $code_verifier      The code verifier. This must match the verifier used for the code challenge in the auth query.
	 *
	 * @return string
	 */
	public static function create(
		$authorization_code,
		$client_id,
		$code_verifier
	) {

		return add_query_arg(
			[
				'grant_type'    => 'authorization_code',
				'code'          => $authorization_code,
				'client_id'     => $client_id,
				'code_verifier' => $code_verifier,
			],
			self::URL
		);
	}
}
