<?php

namespace WPFormsAWeber\Exceptions;

use Exception;

/**
 * Class RequiredArgumentMissing.
 *
 * @since 2.0.0
 */
class RequiredArgumentMissing extends Exception {

	/**
	 * RequiredArgumentMissing constructor.
	 *
	 * @since 2.0.0
	 *
	 * @param string $key Key name.
	 */
	public function __construct( $key ) {

		parent::__construct(
			sprintf( /* translators: %s - required argument key. */
				esc_html__( 'The "%s" is a required argument', 'wpforms-aweber' ),
				sanitize_text_field( $key )
			),
			400
		);
	}
}
