<?php

namespace WPFormsAWeber;

/**
 * AWeber helper utility methods.
 *
 * @since 2.0.0
 */
class Helpers {

	/**
	 * The providers slug used in AWeber OAuth1 connections.
	 *
	 * @since 2.0.0
	 *
	 * @var string
	 */
	const SLUG_OAUTH1 = 'aweber';

	/**
	 * Check if an AWeber OAuth1 providers connection exists.
	 *
	 * @see WPForms_Aweber::api_auth()
	 *
	 * @since 2.0.0
	 *
	 * @param array $providers The providers array.
	 *
	 * @return bool True if a legacy OAuth1 connection exists, false otherwise.
	 */
	public static function providers_has_oauth1_connection( $providers ) {

		// No saved AWeber OAuth 1 connection details.
		if ( ! isset( $providers[ self::SLUG_OAUTH1 ] ) ) {
			return false;
		}

		/**
		 * Loop through AWeber provider connections
		 * and check if any of them are OAuth1.
		 *
		 * @var string $id         The connection ID.
		 * @var array  $connection The AWeber connection details.
		 */
		foreach ( $providers[ self::SLUG_OAUTH1 ] as $connection ) {
			if (
				! empty( $connection['consumer_key'] )
				&& ! empty( $connection['consumer_secret'] )
				&& ! empty( $connection['access_token'] )
				&& ! empty( $connection['access_token_secret'] )
			) {
				return true;
			}
		}

		return false;
	}
}
