<?php

namespace WPFormsAWeber\Provider\Actions;

use WPFormsAWeber\Api\Api;
use WPFormsAWeber\Provider\FieldMapper;

/**
 * Class Action.
 *
 * @since 2.0.0
 */
abstract class Action {

	/**
	 * AWeber API connection.
	 *
	 * @since 2.0.0
	 *
	 * @var Api
	 */
	protected $connection;

	/**
	 * Field mapper.
	 *
	 * @since 2.0.0
	 *
	 * @var FieldMapper
	 */
	protected $field_mapper;

	/**
	 * Connection data.
	 *
	 * @since 2.0.0
	 *
	 * @var array
	 */
	protected $connection_data;

	/**
	 * Form data.
	 *
	 * @since 2.0.0
	 *
	 * @var array
	 */
	protected $form_data;

	/**
	 * Form fields.
	 *
	 * @since 2.0.0
	 *
	 * @var array
	 */
	protected $fields;

	/**
	 * Action constructor.
	 *
	 * @since 2.0.0
	 *
	 * @param Api         $connection      AWeber API connection.
	 * @param FieldMapper $field_mapper    Field mapper.
	 * @param array       $connection_data Form connection data.
	 * @param array       $form_data       Form field settings data.
	 * @param array       $fields          Form field values.
	 */
	public function __construct( Api $connection, FieldMapper $field_mapper, $connection_data, $form_data, $fields ) {

		$this->connection      = $connection;
		$this->field_mapper    = $field_mapper;
		$this->connection_data = $connection_data;
		$this->form_data       = $form_data;
		$this->fields          = $fields;
	}

	/**
	 * Run action.
	 *
	 * @since 2.0.0
	 *
	 * @return void
	 */
	abstract public function run();
}
