<?php

namespace WPFormsAWeber\Provider;

/**
 * Class SingleAccountDTO.
 *
 * A data object representing a single provider options account.
 *
 * @since 2.0.0
 */
class SingleAccountDTO {

	/**
	 * The account ID.
	 *
	 * @since 2.0.0
	 *
	 * @var string
	 */
	private $account_id;

	/**
	 * The OAuth2 PKCE access token.
	 *
	 * @since 2.0.0
	 *
	 * @var string
	 */
	private $access_token;

	/**
	 * The OAuth2 PKCE refresh token.
	 *
	 * @since 2.0.0
	 *
	 * @var string
	 */
	private $refresh_token;

	/**
	 * The OAuth2 PKCE access token expiration timestamp.
	 *
	 * @since 2.0.0
	 *
	 * @var int
	 */
	private $expires_on;

	/**
	 * The account label.
	 *
	 * @since 2.0.0
	 *
	 * @var string
	 */
	private $label;

	/**
	 * SingleAccountDTO constructor.
	 *
	 * @since 2.0.0
	 *
	 * @param string $account_id    The account ID.
	 * @param string $access_token  The OAuth2 PKCE access token.
	 * @param string $refresh_token The OAuth2 PKCE refresh token.
	 * @param int    $expires_on    The OAuth2 PKCE access token expiration timestamp.
	 * @param string $label         The account label.
	 */
	public function __construct(
		$account_id,
		$access_token,
		$refresh_token,
		$expires_on,
		$label
	) {

		$this->account_id    = $account_id;
		$this->access_token  = $access_token;
		$this->refresh_token = $refresh_token;
		$this->expires_on    = $expires_on;
		$this->label         = $label;
	}

	/**
	 * Get account ID.
	 *
	 * @since 2.0.0
	 *
	 * @return string
	 */
	public function get_account_id() {

		return $this->account_id;
	}

	/**
	 * Get access token.
	 *
	 * @since 2.0.0
	 *
	 * @return string
	 */
	public function get_access_token() {

		return $this->access_token;
	}

	/**
	 * Get refresh token.
	 *
	 * @since 2.0.0
	 *
	 * @return string
	 */
	public function get_refresh_token() {

		return $this->refresh_token;
	}

	/**
	 * Get expires on timestamp.
	 *
	 * @since 2.0.0
	 *
	 * @return int
	 */
	public function get_expires_on() {

		return $this->expires_on;
	}

	/**
	 * Get label.
	 *
	 * @since 2.0.0
	 *
	 * @return string
	 */
	public function get_label() {

		return $this->label;
	}
}
