<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="wpforms-builder-provider-connection-block wpforms-builder-aweber-provider-lists">
	<h4><?php esc_html_e( 'Select List', 'wpforms-aweber' ); ?><span class="required">*</span></h4>

	<select class="js-wpforms-builder-aweber-provider-connection-lists wpforms-required" name="providers[{{ data.provider }}][{{ data.connection.id }}][list_id]"<# if ( _.isEmpty( data.lists ) ) { #> disabled<# } #>>

		<# if ( _.isEmpty( data.lists ) ) { #><option value="" selected disabled><?php esc_html_e( '--- No Lists ---', 'wpforms-aweber' ); ?></option><# } else { #><option value=""><?php esc_html_e( '--- Select List ---', 'wpforms-aweber' ); ?></option><# } #>

		<# _.each( data.lists, function( list ) { #>
		<option value="{{ list.id }}" <# if ( data.connection.list_id === list.id ) { #> selected<# } #>>
			{{ list.name }}
		</option>
		<# } ); #>
	</select>

	<# if ( _.isEmpty( data.lists ) ) { #>
		<p class="description error-message">
			<?php esc_html_e( 'You have no list yet. Consider creating at least one.', 'wpforms-aweber' ); ?>
		</p>
	<# } #>
</div>

<div class="wpforms-builder-provider-connection-block wpforms-builder-aweber-provider-actions">
	<h4><?php esc_html_e( 'Action To Perform', 'wpforms-aweber' ); ?><span class="required">*</span></h4>

	<select class="js-wpforms-builder-aweber-provider-connection-action wpforms-required" name="providers[{{ data.provider }}][{{ data.connection.id }}][action]"<# if ( _.isEmpty( data.lists ) ) { #> disabled<# } #>>
		<option value=""><?php esc_html_e( '--- Select Action ---', 'wpforms-aweber' ); ?></option>
		<option value="subscribe"<# if ( 'subscribe' === data.connection.action ) { #> selected<# } #>><?php esc_html_e( 'Subscribe', 'wpforms-aweber' ); ?></option>
	</select>
</div>

<!-- Here is where sub-templates will put its compiled HTML. -->
<div class="wpforms-builder-aweber-provider-actions-data"></div>

{{{ data.conditional }}}
