<?php
/**
 * Subscribe action template.
 *
 * @var array $args HTML markup fields.
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="wpforms-builder-provider-connection-block wpforms-builder-aweber-provider-subscribe">
	<h4><?php esc_html_e( 'Subscribe', 'wpforms-aweber' ); ?></h4>

	<div class="wpforms-builder-provider-connection-setting">
		<?php echo $args['fields']['email']; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		<?php echo $args['fields']['name']; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
	</div>

	<div class="wpforms-builder-provider-connection-settings-group wpforms-builder-aweber-provider-subscribe-tags">
		<div class="wpforms-builder-provider-connection-setting wpforms-builder-aweber-provider-subscribe-tags-add">
			<h4><?php esc_html_e( 'Lead Tags', 'wpforms-aweber' ); ?></h4>

			<label for="wpforms-builder-aweber-provider-{{ data.connection.id }}-subscribe-tags-add">
				<?php esc_html_e( 'Tags To Add', 'wpforms-aweber' ); ?>
			</label>
			<select class="js-wpforms-builder-aweber-provider-item-select choicesjs-select" id="wpforms-builder-aweber-provider-{{ data.connection.id }}-subscribe-tags-add" name="providers[{{ data.provider }}][{{ data.connection.id }}][tags][add][]" multiple>
				<# if ( _.isEmpty( data.tags ) ) { #><option value="" disabled><?php esc_html_e( '--- No Tags ---', 'wpforms-aweber' ); ?></option><# } else { #><option value="" disabled><?php esc_html_e( 'Select tag(s)', 'wpforms-aweber' ); ?></option><# } #>

				<# _.each( data.tags, function( value, key ) { #>
				<option value="{{ value }}"<# if ( ( ! _.isEmpty( data.connection.tag_names ) && _.find( data.connection.tag_names, function( tag ) { return tag == value; } ) ) || ( ! _.isEmpty( data.connection.tag_news ) && _.find( data.connection.tag_news, function( tag ) { return tag == value; } ) ) ) { #> selected<# } #>>
					{{ value }}
				</option>
				<# } ); #>
			</select>
			<p class="description"><?php esc_html_e( 'Select one or more of the existing tags associated with this list.', 'wpforms-aweber' ); ?></p>
		</div>

		<div class="wpforms-builder-provider-connection-setting wpforms-builder-aweber-provider-item-input">
			<label for="wpforms-builder-aweber-provider-{{ data.connection.id }}-tags-new">
				<?php esc_html_e( 'New Tags to Add', 'wpforms-aweber' ); ?>
			</label>
			<input type="text" value="<# if ( ! _.isEmpty( data.connection.tag_news ) ) { if ( ! _.isEmpty( data.tags ) ) { #>{{ _.difference( data.connection.tag_news, data.tags ).join( ',' ) }}<# } else { #>{{ data.connection.tag_news.join( ',' ) }}<# } #><# } #>" class="js-wpforms-builder-aweber-provider-tags-new" id="wpforms-builder-aweber-provider-{{ data.connection.id }}-tags-new" name="providers[{{ data.provider }}][{{ data.connection.id }}][tags][new]" placeholder="<?php esc_attr_e( 'e.g., wpforms', 'wpforms-aweber' ); ?>">
			<p class="description">
				<?php esc_html_e( 'Comma-separated list of new tags is accepted.', 'wpforms-aweber' ); ?>
			</p>
		</div>
	</div>

</div>
