<?php
/**
 * Connected account.
 *
 * @var string $label     Label for connection.
 * @var string $key       Connection key.
 * @var string $core_slug Integration slug.
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<li class="wpforms-clear">
	<span class="label"><?php echo esc_html( $label ); ?></span>
	<span class="date">
		<?php
		printf( /* translators: %s - Connection date. */
			esc_html__( 'Connected on: %s', 'wpforms-aweber' ),
			wpforms_date_format( time() )
		);
		?>
	</span>
	<span class="remove">
		<a href="#"
			data-provider="<?php echo esc_attr( $core_slug ); ?>"
			data-key="<?php echo esc_attr( $key ); ?>">
			<?php esc_html_e( 'Disconnect', 'wpforms-aweber' ); ?>
		</a>
	</span>
</li>
