<?php
/**
 * Translatable provider name.
 *
 * @var string $core_name Integration name.
 */

use WPFormsAWeber\Api\AuthQuery;
use WPFormsAWeber\Api\CodeChallenge;
use WPFormsAWeber\Api\CodeVerifier;
use WPFormsAWeber\Plugin;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

try {
	/**
	 * Note: The same code_verifier used to create the code_challenge
	 * is also required for the token exchange!
	 * Pass it through a hidden or readonly field,
	 * so we can reuse it in verification.
	 */
	$code_verifier = CodeVerifier::create();
} catch ( Exception $e ) {
	$code_verifier = '';
}

try {
	/**
	 * Create the code challenge.
	 */
	$code_challenge = CodeChallenge::create( $code_verifier );
} catch ( Exception $e ) {
	$code_challenge = '';
}

if ( empty( $code_verifier ) || empty( $code_challenge ) ) {
	?>
	<p>
		<?php esc_html_e( 'Something went wrong while creating the code challenge.', 'wpforms-aweber' ); ?>
	</p>
	<p>
		<?php esc_html_e( 'Please try refreshing the page.', 'wpforms-aweber' ); ?>
	</p>
	<?php

	return;
}

$auth_query = AuthQuery::create( Plugin::APP_CLIENT_ID, $code_challenge );

$authorization_code_placeholder = sprintf( /* translators: %s - current provider name. */
	__( '%s Authorization Code *', 'wpforms-aweber' ),
	$core_name
);

$label_placeholder = sprintf( /* translators: %s - current provider name. */
	__( '%s Account Nickname', 'wpforms-aweber' ),
	$core_name
);

?>
<p>
	<?php
	printf(
		wp_kses( /* translators: %1$s - Authorization URL. */
			__(
				'Before you add your account, you must <a class="wpforms-aweber_v2-auth" href="%1$s" rel="noopener" target="_blank">authorize the connection with AWeber</a>.',
				'wpforms-aweber'
			),
			[
				'a' => [
					'class'  => [],
					'href'   => [],
					'rel'    => [],
					'target' => [],
				],
			]
		),
		esc_url_raw( $auth_query )
	);
	?>
</p>
<p>
	<?php
	printf(
		wp_kses( /* translators: %1$s - Documentation URL. */
			__(
				'If you need help connecting WPForms to AWeber, <a class="wpforms-aweber_v2-docs" href="%1$s" rel="noopener" target="_blank">read our documentation</a>.',
				'wpforms-aweber'
			),
			[
				'a' => [
					'class'  => [],
					'href'   => [],
					'rel'    => [],
					'target' => [],
				],
			]
		),
		esc_url( wpforms_utm_link( 'https://wpforms.com/docs/install-use-aweber-addon-wpforms/#update-integration', 'Settings - Integration', 'AWeber Documentation' ) )
	);
	?>
</p>
<p>
	<input type="hidden" name="code_verifier"
		   class="wpforms-aweber_v2-code_verifier"
		   value="<?php echo esc_attr( $code_verifier ); ?>">
	<input type="text" name="authorization_code"
		   class="wpforms-required"
		   placeholder="<?php echo esc_attr( $authorization_code_placeholder ); ?>">
	<span class="error" style="display: none;"></span>
</p>
<p>
	<input type="text" name="label"
		   placeholder="<?php echo esc_attr( $label_placeholder ); ?>">
</p>
<p class="error form-error" style="display: none">
	<?php esc_html_e( 'Something went wrong while performing an AJAX request.', 'wpforms-aweber' ); ?>
</p>
