<?php
/**
 * Plugin Name:       WPForms AWeber
 * Plugin URI:        https://wpforms.com
 * Description:       AWeber integration with WPForms.
 * Requires at least: 5.2
 * Requires PHP:      5.6
 * Author:            WPForms
 * Author URI:        https://wpforms.com
 * Version:           2.0.1
 * Text Domain:       wpforms-aweber
 * Domain Path:       languages
 *
 * WPForms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * WPForms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WPForms. If not, see <https://www.gnu.org/licenses/>.
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use WPFormsAWeber\Plugin;

/**
 * Plugin version.
 *
 * @since 1.0.0
 */
const WPFORMS_AWEBER_VERSION = '2.0.1';

/**
 * Plugin file.
 *
 * @since 1.0.0
 */
const WPFORMS_AWEBER_FILE = __FILE__;

/**
 * Plugin path.
 *
 * @since 2.0.0
 */
define( 'WPFORMS_AWEBER_PATH', plugin_dir_path( WPFORMS_AWEBER_FILE ) );

/**
 * Plugin URL.
 *
 * @since 2.0.0
 */
define( 'WPFORMS_AWEBER_URL', plugin_dir_url( WPFORMS_AWEBER_FILE ) );

/**
 * Check addon requirements.
 *
 * @since 1.0.0
 * @since 2.0.1 Uses requirements feature.
 */
function wpforms_aweber_load() {

	$requirements = [
		'file'    => WPFORMS_AWEBER_FILE,
		'wpforms' => '1.8.3',
	];

	if ( ! function_exists( 'wpforms_requirements' ) || ! wpforms_requirements( $requirements ) ) {
		return;
	}

	wpforms_aweber();
}

add_action( 'wpforms_loaded', 'wpforms_aweber_load' );

/**
 * Get the instance of the addon main class.
 *
 * @since 2.0.0
 *
 * @return Plugin
 */
function wpforms_aweber() {

	require_once WPFORMS_AWEBER_PATH . 'vendor/autoload.php';

	return Plugin::get_instance();
}
