<?php

namespace WPFormsPaypalCommerce\Migrations;

use WPForms\Migrations\UpgradeBase;

/**
 * Upgrade routine for version 1.3.0.
 *
 * @since 1.3.0
 */
class Upgrade130 extends UpgradeBase {

	/**
	 * Change subscription period from 'semi-yearly' to 'semiyearly' in DB for PP Commerce subscriptions.
	 *
	 * @since 1.3.0
	 *
	 * @return bool
	 */
	public function run() {

		global $wpdb;

		// phpcs:disable WordPress.DB.DirectDatabaseQuery.NoCaching
		$wpdb->query(
			"UPDATE {$wpdb->prefix}wpforms_payments p
			INNER JOIN {$wpdb->prefix}wpforms_payment_meta m ON p.id = m.payment_id 
			SET m.meta_value = 'semiyearly' 
			WHERE p.gateway = 'paypal_commerce' 
			AND p.type = 'subscription' 
			AND m.meta_key = 'subscription_period' 
			AND m.meta_value = 'semi-yearly'"
		);
		// phpcs:enable WordPress.DB.DirectDatabaseQuery.NoCaching

		return empty( $wpdb->last_error );
	}
}
