<?php
/**
 * Plugin Name:       WPForms PayPal Commerce
 * Plugin URI:        https://wpforms.com
 * Description:       PayPal Commerce integration with WPForms.
 * Author:            WPForms
 * Author URI:        https://wpforms.com
 * Version:           1.5.0
 * Requires at least: 5.2
 * Requires PHP:      5.6
 * Text Domain:       wpforms-paypal-commerce
 * Domain Path:       languages
 *
 * WPForms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * WPForms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WPForms. If not, see <https://www.gnu.org/licenses/>.
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use WPFormsPaypalCommerce\Plugin;

/**
 * Plugin version.
 *
 * @since 1.0.0
 */
const WPFORMS_PAYPAL_COMMERCE_VERSION = '1.5.0';

/**
 * Plugin file.
 *
 * @since 1.0.0
 */
const WPFORMS_PAYPAL_COMMERCE_FILE = __FILE__;

/**
 * Plugin path.
 *
 * @since 1.0.0
 */
define( 'WPFORMS_PAYPAL_COMMERCE_PATH', plugin_dir_path( WPFORMS_PAYPAL_COMMERCE_FILE ) );

/**
 * Plugin URL.
 *
 * @since 1.0.0
 */
define( 'WPFORMS_PAYPAL_COMMERCE_URL', plugin_dir_url( WPFORMS_PAYPAL_COMMERCE_FILE ) );

/**
 * Check addon requirements.
 *
 * @since 1.0.0
 */
function wpforms_paypal_commerce_load() {

	$requirements = [
		'file'    => WPFORMS_PAYPAL_COMMERCE_FILE,
		'wpforms' => '1.8.3',
	];

	if ( ! function_exists( 'wpforms_requirements' ) || ! wpforms_requirements( $requirements ) ) {
		return;
	}

	wpforms_paypal_commerce();
}

add_action( 'wpforms_loaded', 'wpforms_paypal_commerce_load' );

/**
 * Get the instance of the addon main class.
 *
 * @since 1.0.0
 *
 * @return Plugin
 */
function wpforms_paypal_commerce() {

	require_once WPFORMS_PAYPAL_COMMERCE_PATH . 'vendor/autoload.php';

	return Plugin::get_instance();
}
