<?php
/**
 * Theme functions and definitions.
 */
function sala_child_enqueue_styles() {

    if ( SCRIPT_DEBUG ) {
        wp_enqueue_style( 'sala-style' , get_template_directory_uri() . '/style.css' );
    }

    wp_enqueue_style( 'sala-child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array( 'sala-style' ),
        wp_get_theme()->get('Version')
    );
}

add_action(  'wp_enqueue_scripts', 'sala_child_enqueue_styles' );
add_action( 'init', 'codex_book_init' );
/**
 * Register a book post type.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_post_type
 */
function codex_book_init() {
	$labels = array(
		'name'               => _x( 'Events ', 'post type general name', 'your-plugin-textdomain' ),
		'singular_name'      => _x( 'Events', 'post type singular name', 'your-plugin-textdomain' ),
		'menu_name'          => _x( 'Events', 'admin menu', 'your-plugin-textdomain' ),
		'name_admin_bar'     => _x( 'Events', 'add new on admin bar', 'your-plugin-textdomain' ),
		'add_new'            => _x( 'Add New', 'events', 'your-plugin-textdomain' ),
		'add_new_item'       => __( 'Add New events', 'your-plugin-textdomain' ),
		'new_item'           => __( 'New events', 'your-plugin-textdomain' ),
		'edit_item'          => __( 'Edit events', 'your-plugin-textdomain' ),
		'view_item'          => __( 'View events', 'your-plugin-textdomain' ),
		'all_items'          => __( 'All Events', 'your-plugin-textdomain' ),
		'search_items'       => __( 'Search Events', 'your-plugin-textdomain' ),
		'parent_item_colon'  => __( 'Parent Events:', 'your-plugin-textdomain' ),
		'not_found'          => __( 'No events found.', 'your-plugin-textdomain' ),
		'not_found_in_trash' => __( 'No events found in Trash.', 'your-plugin-textdomain' )
	);

	$args = array(
		'labels'             => $labels,
		'description'        => __( 'Description.', 'your-plugin-textdomain' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'events' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments' )
	);

	register_post_type( 'events', $args );
}
function wpc_vc_shortcode( $atts ) {
	
	?>

<div class="container">
  <div class="crs-slider">
    <div class="regulars">
      <?php $loop = new WP_Query( array( 'post_type' => 'events', 'posts_per_page' => 1, 'order' => 'ASC'  ) ); ?>
      <?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
      <div class="crs-sld">
		  <a href="<?php the_field('custom_link'); ?>">
        <div class="imag">
          <?php if(has_post_thumbnail() ) { the_post_thumbnail(); } ?>
        </div>  </a>
		<div class="evnt-video">
			    <?php the_field('video'); ?>

			  </div>
        <div class="crs-cnt">
        <!-- <a href="<?php //the_field('custom_link'); ?>">  <h2><?php //the_title();?> </h2> </a>-->
         <div class="contanevt">
			 <?php the_content();?>
			</div>     
        </div> 
		
      </div>
      <?php endwhile; ?>
      <?php wp_reset_query(); ?>
    </div>
  </div>
</div>

<?php
}
add_shortcode( 'my_vc_php_output', 'wpc_vc_shortcode');

function wpc_vc_cor( $atts ) {
	
	?>
 
<?php
}
add_shortcode( 'courcies_page', 'wpc_vc_cor');